<?php
/**
 * The settings functionality of the plugin.
 *
 * This class defines all code necessary to have setting pages and manager.
 *
 * @since      1.0
 * @package    WP_SHORTCODE
 * @subpackage WP_SHORTCODE/includes
 * @author     MyThemeShop <admin@mythemeshop.com>
 */
class WP_Shortcode_Settings extends WP_Shortcode_Base {

	/**
	 * [private description]
	 * @var [type]
	 */
	private $keys = array();

	/**
	 * Options holder.
	 * @var array
	 */
	private $options = null;

	/**
	 * The Constructor
	 */
	public function __construct() {

		// CMB2 Custom Fields
		if ( ! has_action( 'cmb2_render_switch' ) ) {
			$this->add_action( 'cmb2_render_switch', 'render_switch', 10, 5 );
		}
		if ( ! has_action( 'cmb2_render_notice' ) ) {
			$this->add_action( 'cmb2_render_notice', 'render_notice' );
		}
		if ( ! has_action( 'cmb2_render_address' ) ) {
			$this->add_action( 'cmb2_render_address', 'render_address', 10, 5 );
		}

		// Add fields
		$this->add_action( 'init', 'general_settings' );

		// Add options data to stream
		$this->add_options( 'general', 'wp-shortcode-options-general' );

		// Check for fields and act accordingly
		$this->add_action( 'cmb2_save_options-page_fields_wp-shortcode-options-general_options', 'check_updated_fields', 25, 2 );

		// $this->add_action( 'wp_ajax_wps_import_settings', 'wps_import_settings_callback');
		$this->add_action( 'wp_ajax_wps_get_settings', 'wps_get_settings_callback');
		$this->add_action( 'wp_ajax_wps_download_settings', 'wps_download_settings', 1, 1 );
	}

	/**
	 * General Settings
	 * @return [type] [description]
	 */
	public function general_settings() {

		$tabs = wp_shortcode_filter( 'general_settings', array(
			'settings'	=> array(
				'icon'	=> 'fa fa-cog',
				'title'	=> __( 'General Settings', 'wp-shortcode-pro' ),
				'desc'	=> '',
			),
			'import'	=> array(
				'icon'	=> 'fa fa-download',
				'title'	=> __( 'Import/Export', 'wp-shortcode-pro' ),
				'desc'	=> '',
			),
		) );

		new WP_Shortcode_Admin_Options( array(
			'key'			=> 'wp-shortcode-options-general',
			'title'			=> __( 'WP Shortcode Settings', 'wp-shortcode-pro' ),
			'menu_title'	=> __( 'General Settings', 'wp-shortcode-pro' ),
			'folder'		=> 'general',
			'tabs'			=> $tabs,
		));
	}

	/**
	 * [render_switch description]
	 * @param  [type] $field             [description]
	 * @param  [type] $escaped_value     [description]
	 * @param  [type] $object_id         [description]
	 * @param  [type] $object_type       [description]
	 * @param  [type] $field_type_object [description]
	 * @return [type]                    [description]
	 */
	public function render_switch( $field, $escaped_value, $object_id, $object_type, $field_type_object ) {

		$field->args['options'] = array(
			'off'	=> esc_html( $field->get_string( 'off', __( 'Off', 'wp-shortcode-pro' ) ) ),
			'on'	=> esc_html( $field->get_string( 'on', __( 'On', 'wp-shortcode-pro' ) ) ),
		);
		$field->set_options();

		echo $field_type_object->radio_inline();
	}

	/**
	 * [render_notice description]
	 * @param  [type] $field             [description]
	 * @return [type]                    [description]
	 */
	public function render_notice( $field ) {

		$hash = array(
			'error' => 'notice notice-alt notice-error error inline',
		);

		echo '<div class="' . $hash[ $field->args( 'what' ) ] . '"><p>' . $field->args( 'content' ) . '</p></div>';
	}

	/**
	 * [render_address description]
	 * @param  [type] $field             [description]
	 * @param  [type] $escaped_value     [description]
	 * @param  [type] $object_id         [description]
	 * @param  [type] $object_type       [description]
	 * @param  [type] $field_type_object [description]
	 * @return [type]                    [description]
	 */
	public function render_address( $field, $escaped_value, $object_id, $object_type, $field_type_object ) {

		// Make sure we assign each part of the value we need.
		$value = wp_parse_args( $escaped_value, array(
			'street'	=> '',
			'locality'	=> '',
			'region'	=> '',
			'zip'		=> '',
			'country'	=> '',
		) );

		$strings = array(
			'street'	=> 'Street Address',
			'locality'	=> 'Locality',
			'region'	=> 'Region',
			'zip'		=> 'Postal Code',
			'country'	=> 'Country',
		);

		foreach ( array_keys( $value ) as $id ) :
			echo '<div class="mb5">' . $field_type_object->input( array(
				'name'			=> $field_type_object->_name( '[' . $id . ']' ),
				'id'			=> $field_type_object->_id( '_' . $id ),
				'value'			=> $value[ $id ],
				'placeholder'	=> esc_html( $field->get_string( $id . '_text', $strings[ $id ] ) ),
			) ) . '</div>';
		endforeach;
	}

	/**
	 * [check_updated_fields description]
	 * @param  [type] $object_id [description]
	 * @param  [type] $$updated  [description]
	 * @return [type]            [description]
	 */
	public function check_updated_fields( $object_id, $updated ) {

		if(isset($_REQUEST['wps_import_type']) && $_REQUEST['wps_import_type'] !== '') {
			$import = '';
			$import_type = $_REQUEST['wps_import_type'];
			if($import_type == 'import_file') {
				$import = file_get_contents( $_FILES['wps-import-file']['tmp_name'] );
			} elseif($import_type === 'import_code') {
				$import = stripslashes($_REQUEST['import_settings']);
			} elseif($import_type === 'import_demo') {
				$args = array(
					'post_title'	=> 'WP Shortcode Demo',
					'post_content'	=> $this->wps_demo_content(),
					'post_type'		=> 'page',
					'post_status'	=> 'publish'
				);
				$demo_page_id = wp_insert_post($args);
				update_option('wps_demo_page', $demo_page_id);
			}

			if($import) {
				$this->wps_import_settings_callback($import);
			}
		}
	}

	public function wps_demo_content() {
		$prefix = wps_prefix();
		ob_start();
		?>
		<div>
			<h3>Alert</h3>[wps_clipboard][wps_alert type="primary"]This is an alert—check it out![/wps_alert][/wps_clipboard][wps_spacer size="15"][wps_alert type="primary"]This is a primary alert—check it out![/wps_alert][wps_alert type="secondary"]This is a secondary alert—check it out![/wps_alert][wps_alert type="success"]This is a primary alert—check it out![/wps_alert][wps_alert type="warning"]This is a secondary alert—check it out![/wps_alert][wps_alert type="important"]This is an important alert—check it out![/wps_alert][wps_alert type="info"]This is a info alert—check it out![/wps_alert][wps_alert type="light"]This is a light alert—check it out![/wps_alert][wps_alert type="dark"]This is a dark alert—check it out![/wps_alert][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Heading</h3>[wps_clipboard][wps_heading align="left" size="18" margin="20"]Custom Heading Text[/wps_heading][/wps_clipboard][wps_spacer size="15"][wps_heading align="left" size="18" margin="20"]Custom Heading Text[/wps_heading][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Tabs</h3>[wps_row][wps_column size="1-2" center="no"]<strong>Horizontal Tabs</strong>[wps_clipboard][wps_tabs active="1" vertical="no"][wps_tab title="Tab-1" disabled="no" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][wps_tab title="Tab-2" disabled="no" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][wps_tab title="Disabled Tab" disabled="yes" target="blank"][/wps_tab][wps_tab title="Link Tab" disabled="no" url="https://mythemeshop.com" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][/wps_tabs][/wps_clipboard][wps_spacer size="15"][wps_tabs active="1" vertical="no"][wps_tab title="Tab-1" disabled="no" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][wps_tab title="Tab-2" disabled="no" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][wps_tab title="Disabled Tab" disabled="yes" target="blank"][/wps_tab][wps_tab title="Link Tab" disabled="no" url="https://mythemeshop.com" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][/wps_tabs][/wps_column][wps_column size="1-2" center="no"]<strong>Vertical Tabs</strong>[wps_clipboard][wps_tabs active="1" vertical="yes"][wps_tabs active="1" vertical="yes"][wps_tab title="Tab-1" disabled="no" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][wps_tab title="Tab-2" disabled="no" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][wps_tab title="Disabled Tab" disabled="yes" target="blank"][/wps_tab][wps_tab title="Link Tab" disabled="no" url="https://mythemeshop.com" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][/wps_tabs][/wps_clipboard][wps_spacer size="15"][wps_tabs active="1" vertical="yes"][wps_tab title="Tab-1" disabled="no" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][wps_tab title="Tab-2" disabled="no" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][wps_tab title="Disabled Tab" disabled="yes" target="blank"][/wps_tab][wps_tab title="Link Tab" disabled="no" url="https://mythemeshop.com" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_tab][/wps_tabs][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Accordion</h3>[wps_clipboard][wps_accordion][wps_accordion_item title="Collapsible Item 1″ open="yes" style="default" icon="caret"]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven"t heard of them accusamus labore sustainable VHS.[/wps_accordion_item][wps_accordion_item title="Collapsible Item 2″ open="no" style="fancy" icon="caret"]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven"t heard of them accusamus labore sustainable VHS.[/wps_accordion_item][wps_accordion_item title="Collapsible Item 3″ open="no" style="default" icon="caret"]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven"t heard of them accusamus labore sustainable VHS.[/wps_accordion_item][/wps_accordion][/wps_clipboard][wps_spacer size="15"][wps_accordion][wps_accordion_item title="Collapsible Item 1″ open="yes" style="default" icon="caret"]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven"t heard of them accusamus labore sustainable VHS.[/wps_accordion_item][wps_accordion_item title="Collapsible Item 2″ open="no" style="fancy" icon="caret"]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven"t heard of them accusamus labore sustainable VHS.[/wps_accordion_item][wps_accordion_item title="Collapsible Item 3″ open="no" style="default" icon="caret"]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven"t heard of them accusamus labore sustainable VHS.[/wps_accordion_item][/wps_accordion][wps_spacer size="10"][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Highlight</h3>[wps_clipboard][wps_highlight background="#36b513" color="#ffffff"]Highlighted text[/wps_highlight][/wps_clipboard][wps_spacer size="15"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. [wps_highlight background="#36b513" color="#ffffff"]Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.[/wps_highlight] Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Quote</h3>[wps_clipboard][wps_quote style="default" cite="Cameron Moll" url="#"]What separates design from art is that design is meant to be… functional.[/wps_quote][/wps_clipboard][wps_spacer size="15"][wps_quote style="default" cite="Cameron Moll" url="#"]What separates design from art is that design is meant to be… functional.[/wps_quote][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Pullquote</h3>[wps_clipboard][wps_pullquote align="left"]Content...[/wps_pullquote][/wps_clipboard][wps_spacer size="15"]<strong>Align - Left</strong>[wps_pullquote align="left"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.[/wps_pullquote] Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.[wps_spacer size="40"]<strong>Align - Right</strong>[wps_pullquote align="right"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.[/wps_pullquote] Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Dropcap</h3>[wps_clipboard][wps_dropcap style="default" size="2"]L[/wps_dropcap][/wps_clipboard][wps_spacer size="15"][wps_dropcap style="default" size="2"]L[/wps_dropcap]orem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[wps_dropcap style="flat" size="2"]L[/wps_dropcap]orem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[wps_dropcap style="light" size="2"]L[/wps_dropcap]orem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[wps_dropcap style="simple" size="3"]L[/wps_dropcap]orem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Frame</h3>[wps_clipboard][wps_frame style="default" align="left"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_frame][/wps_clipboard][wps_spacer size="15"][wps_frame style="default" align="left"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_frame][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Columns</h3>[wps_clipboard][wps_heading align="left" size="18" margin="20"]Custom Heading Text[/wps_heading][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-1" center="no"]<strong>Full width column.</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][/wps_row][wps_row][wps_column size="1-2" center="no"]<strong>1/2 Column:</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][wps_column size="1-2" center="no"]<strong>1/2 Column:</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][/wps_row][wps_row][wps_column size="1-3" center="no"]<strong>1/3 Column:</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_column][wps_column size="2-3" center="no"]<strong>2/3 Column:</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][/wps_row][wps_row][wps_column size="1-4" center="no"]<strong>1/4 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_column][wps_column size="3-4" center="no"]<strong>3/4 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][/wps_row][wps_row][wps_column size="1-5" center="no"]<strong>1/5 Column:</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_column][wps_column size="2-5" center="no"]<strong>2/5 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][wps_column size="2-5" center="no"]<strong>2/5 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][/wps_row][wps_row][wps_column size="3-5" center="no"]<strong>3/5 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][wps_column size="2-5" center="no"]<strong>2/5 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.[/wps_column][/wps_row][wps_row][wps_column size="4-5" center="no"]<strong>4/5 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][wps_column size="1-5" center="no"]<strong>1/5 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.[/wps_column][/wps_row][wps_row][wps_column size="1-6" center="no"]<strong>1/6 Column</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit[/wps_column][wps_column size="5-6" center="no"]<strong>5/6 Column:</strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>List</h3>[wps_clipboard][wps_lists icon="arrow-right" icon_color="#1c7bdb"]<ul> <li>List item</li><li>List item</li><li>List item</li></ul>[/wps_lists][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size='1-4' center='no'][wps_lists icon="arrow-right" icon_color="#1c7bdb"]<ul> <li>List item</li><li>List item</li><li>List item</li></ul>[/wps_lists][/wps_column][wps_column size='1-4' center='no'][wps_lists icon="check" icon_color="#0b6577"]<ul> <li>List item</li><li>List item</li><li>List item</li></ul>[/wps_lists][/wps_column][wps_column size='1-4' center='no'][wps_lists icon="exclamation" icon_color="#dd3333"]<ul> <li>List item</li><li>List item</li><li>List item</li></ul>[/wps_lists][/wps_column][wps_column size='1-4' center='no'][wps_lists icon="pencil-square-o" icon_color="#81d742"]<ul> <li>List item</li><li>List item</li><li>List item</li></ul>[/wps_lists][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Icon List</h3>[wps_clipboard][wps_icon_list icon="check-square-o" title="List Title" align="left" color="#000000" shadow="0px 0px 0px " border="0px " radius="0" url="#" size="20" animate="push"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_icon_list][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size='1-3' center='no'][wps_icon_list icon="check-square-o" title="List Title" align="left" color="#000000" shadow="0px 0px 0px " border="0px " radius="0" url="#" size="20" animate="push"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_icon_list][/wps_column][wps_column size='1-3' center='no'][wps_icon_list icon="heart" title="List Title" align="center" background="#dd3333" color="#ffffff" shadow="0px 0px 0px " border="0px " radius="50" url="#" size="20" animate="push"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_icon_list][/wps_column][wps_column size='1-3' center='no'][wps_icon_list icon="plus" title="List Title" align="title" color="#1fc6bb" shadow="0px 0px 0px " border="0px " radius="2" url="#" size="20" animate="push"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.[/wps_icon_list][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Buttons</h3>[wps_clipboard][wps_button style="bordered" desc="Button description" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" icon="heart-o" icon_color="#ffffff" wide="no" position="left" radius="auto" text_shadow="0px 1px 1px #000" rel="nofollow" title="Default Button" id="default-button"]Button text[/wps_button][/wps_clipboard][wps_spacer size="15"][wps_button style="default" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" wide="no" position="left" radius="0" text_shadow="none"]Default Button[/wps_button][wps_button style="bordered" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" wide="no" position="left" radius="0" text_shadow="none"]Bordered Button[/wps_button][wps_button style="stroked" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" wide="no" position="left" radius="0" text_shadow="none"]Stroked Button[/wps_button][wps_button style="3d" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" wide="no" position="left" radius="0" text_shadow="none"]3D Button[/wps_button][wps_button style="default" desc="Test Desc" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" icon="bell" icon_color="#fcfcfc" wide="no" position="left" radius="0" text_shadow="0px 0px 0px #000000"]Button text[/wps_button][wps_button style="default" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" icon="bell-o" icon_color="#ffffff" wide="no" position="left" radius="0" text_shadow="0px 0px 0px #000000"]Button with icon[/wps_button][wps_button style="default" desc="Sub title" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" wide="no" position="left" radius="0" text_shadow="none"]Button with description[/wps_button][wps_button style="default" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" wide="no" position="left" radius="round" text_shadow="none"]Rounded button[/wps_button][wps_button style="default" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="40" wide="no" position="left" radius="0" text_shadow="none"]Large button[/wps_button][wps_spacer size="5"][wps_button style="default" url="#" target="self" background="#2D89EF" color="#FFFFFF" size="13" wide="yes" position="left" radius="0" text_shadow="none"]Wide Button[/wps_button][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Double Buttons</h3>[wps_clipboard][wps_double_button left_btn_text="Login" left_desc="Already a member?" left_url="" left_btn_target="self" left_icon="user" left_background="#2D89EF" left_color="#FFFFFF" separator_text="OR" right_btn_text="Register" right_desc="Not a member yet?" right_url="#" right_btn_target="self" right_icon="user" right_background="#2D89EF" right_color="#FFFFFF" size="13" radius="0"][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-2" center="no"][wps_double_button left_btn_text="Join" left_desc="Click to register" left_url="#" left_btn_target="self" left_icon="user" left_background="#dd3333" left_color="#FFFFFF" separator_text="or" right_btn_text="Login" right_desc="Click to login" right_url="#" right_btn_target="self" right_icon="arrow-right" right_background="#39c619" right_color="#FFFFFF" size="16" radius="100"][/wps_column][wps_column size="1-2" center="no"][wps_double_button left_btn_text="Join" left_desc="Click to register" left_url="#" left_btn_target="self" left_icon="user" left_background="#dd3333" left_color="#FFFFFF" separator_text="or" right_btn_text="Login" right_desc="Click to login" right_url="#" right_btn_target="self" right_icon="arrow-right" right_background="#39c619" right_color="#FFFFFF" size="16" radius="0"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Services</h3>[wps_clipboard][wps_service title="Service title" icon="cog" icon_color="#333333" size="32"]Service description[/wps_service][/wps_clipboard][wps_spacer size="15"][wps_service title="Service title" icon="bell" icon_color="#c1592c" size="24"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_service][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Box</h3>[wps_clipboard][wps_box title="Box title" box_color="#333333" title_color="#FFFFFF" radius="0"]Box content[/wps_box][/wps_clipboard][wps_spacer size="15"][wps_box title="Box title" box_color="#000000" title_color="#FFFFFF" radius="10"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_box][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Note</h3>[wps_clipboard][wps_note size="14" background="#e8dd63" color="#444" radius="3"]Note text[/wps_note][/wps_clipboard][wps_spacer size="15"][wps_note size="14" note_color="#FFFF66" text_color="#333333" radius="3"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_note][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Expand</h3>[wps_clipboard][wps_expand more_text="Show more" less_text="Show less" height="20" hide_less="no" text_color="#333333" link_color="#0088FF" link_style="default" link_align="left" more_icon="chevron-down" less_icon="chevron-up"]Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi.[/wps_expand][/wps_clipboard][wps_spacer size="15"][wps_expand more_text="Show more" less_text="Show less" height="20" hide_less="no" text_color="#333333" link_color="#0088FF" link_style="default" link_align="left" more_icon="chevron-down" less_icon="chevron-up"]Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi.[/wps_expand][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Lightbox</h3>[wps_clipboard][wps_lightbox type="image" src="https://demo.mythemeshop.com/bridge/files/2015/12/pexels-photo-109275-582x298.jpeg"]Click here to open lightbox[/wps_lightbox][/wps_clipboard][wps_spacer size="15"][wps_lightbox type="image" src="https://demo.mythemeshop.com/bridge/files/2015/12/pexels-photo-109275-582x298.jpeg"]Click here to open lightbox[/wps_lightbox][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Tooltip</h3>[wps_clipboard][wps_tooltip position="left" size="13" content="Tooltip left" behavior="hover"]Hover me to open tooltip[/wps_tooltip][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-4"][wps_tooltip position="left" size="13" content="Tooltip left" behavior="hover"]Hover me to open tooltip[/wps_tooltip][/wps_column][wps_column size="1-4"][wps_tooltip position="top-left" size="13" content="Tooltip top-left" behavior="hover"]Hover me to open tooltip[/wps_tooltip][/wps_column][wps_column size="1-4"][wps_tooltip position="top-center" size="13" content="Tooltip top-center" behavior="hover"]Hover me to open tooltip[/wps_tooltip][/wps_column][wps_column size="1-4"][wps_tooltip position="top-right" size="13" content="Tooltip top-right" behavior="hover"]Hover me to open tooltip[/wps_tooltip][/wps_column][/wps_row][wps_row][wps_column size="1-4"][wps_tooltip position="bottom-left" size="13" content="Tooltip bottom-left" behavior="click"]Click me to open tooltip[/wps_tooltip][/wps_column][wps_column size="1-4"][wps_tooltip position="bottom-center" size="13" content="Tooltip bottom-center" behavior="click"]Click me to open tooltip[/wps_tooltip][/wps_column][wps_column size="1-4"][wps_tooltip position="bottom-right" size="13" content="Tooltip bottom-right" behavior="click"]Click me to open tooltip[/wps_tooltip][/wps_column][wps_column size="1-4"][wps_tooltip position="right" size="13" content="Tooltip right" behavior="always"]Always open[/wps_tooltip][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Call To Action</h3>[wps_clipboard][wps_calltoaction title="Call to action left align" align="left" background="#f5f5f5" color="#666" radius="0" text="Purchase Now" url="#" target="self" button_background="#444" button_color="#e5e5e5" button_radius="0"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.[/wps_calltoaction][/wps_clipboard][wps_row][wps_column size="1-1"][wps_calltoaction title="Call to action left align" align="left" background="#f5f5f5" color="#666" radius="0" button_text="Purchase Now" url="#" target="self" button_background="#444" button_color="#e5e5e5" button_radius="0"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.[/wps_calltoaction][/wps_column][/wps_row][wps_row][wps_column size="1-1"][wps_calltoaction title="Call to action right align" align="right" background="#418cd8" color="#ffffff" radius="0" button_text="Purchase Now" url="#" target="self" button_background="#93aabf" button_color="#ffffff" button_radius="0"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.[/wps_calltoaction][/wps_column][/wps_row][wps_row][wps_column size="1-1"][wps_calltoaction title="Call to action center align" align="center" background="#cc2e2e" color="#ffffff" radius="0" button_text="Purchase Now" url="#" target="self" button_background="#cc5b5b" button_color="#ffffff" button_radius="0"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.[/wps_calltoaction][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Counter</h3>[wps_clipboard][wps_counter count_start="0" count_end="400000" align="left" count_color="#1abc9c" text_color="#666" prefix="" suffix="" separator="," decimal="" duration="3" size="medium"]Happy clients[/wps_counter][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-3"]<strong>Small Size</strong>[wps_counter count_start="0" count_end="400000" align="left" count_color="#1abc9c" text_color="#666" prefix="" suffix="" separator="," decimal="" duration="3" size="medium"]Happy clients[/wps_counter][/wps_column][wps_column size="1-3"]<strong>Medium Size</strong>[wps_counter count_start="0" count_end="400" align="left" count_color="#cc2e2e" text_color="#666" prefix="$" suffix="/-" separator="," decimal="" duration="3" size="medium"]Price[/wps_counter][/wps_column][wps_column size="1-3"]<strong>Large Size</strong>[wps_counter count_start="0" count_end="5845.58" align="left" count_color="#418cd8" text_color="#666" prefix="$" suffix="/-" separator="," decimal="." duration="3" size="medium"]Price[/wps_counter][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Countdown</h3>[wps_clipboard][wps_countdown date="2018/7/13" time="11:35:58" align="left" size="40" count_color="#1abc9c" background="#eee" padding="20"]This offer has expired![/wps_countdown][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-1" center="no"][wps_countdown date="2018/7/13" time="11:35:58" align="left" size="40" count_color="#1abc9c" background="#eee" padding="20"]This offer has expired![/wps_countdown][/wps_column][wps_spacer size="20"][wps_column size="1-1" center="no"][wps_countdown date="2018/7/13" time="11:35:58" align="left" size="50" count_color="#cc2e2e" background="#eee" padding="20"]This offer has expired![/wps_countdown][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Testimonial</h3>[wps_clipboard][wps_testimonial name="John Doe" designation="Developer" company="MyThemeShop pvt Ltd" radius="5" image="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mm&amp;f=y"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[/wps_testimonial][/wps_clipboard][wps_spacer size="15"][wps_testimonial name="John Doe" designation="Developer" company="MyThemeShop pvt Ltd" radius="5" image="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mm&amp;f=y"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[/wps_testimonial][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Progress Bar/Pie</h3>[wps_clipboard][wps_progress_bar style="default" percent="70" text="UI" text_position="over" show_percent="yes" bar_color="#1ABC9C" text_color="#fff" fill_color="#f2f2f2" height="20" radius="10" duration="1.2" delay="5"][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-2"]<strong>Default</strong>[wps_progress_bar style="default" percent="70" text="UI" text_position="over" show_percent="yes" bar_color="#1ABC9C" text_color="#fff" fill_color="#f2f2f2" height="20" radius="10" duration="1.2" delay="5"][/wps_column][wps_column size="1-2" center="no"]<strong>Striped</strong>[wps_progress_bar style="striped" percent="53" text="PHP" text_position="over" show_percent="yes" bar_color="#1ABC9C" text_color="#fff" fill_color="#f2f2f2" height="20" radius="10" duration="1.2" delay="5"][/wps_column][wps_column size="1-2"]<strong>Animated</strong>[wps_progress_bar style="animated" percent="93" text="HTML" text_position="over" show_percent="yes" bar_color="#1ABC9C" text_color="#fff" fill_color="#f2f2f2" height="20" radius="10" duration="1.2" delay="5"][/wps_column][wps_column size="1-2"]<strong>Pie</strong>[wps_progress_bar style="pie" percent="90" text="JavaScript" text_position="over" show_percent="yes" bar_color="#1ABC9C" text_color="#444" fill_color="#f2f2f2" height="20" radius="10" duration="1.2" delay="5"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Modal</h3>[wps_clipboard][wps_modal effect="1" button_text="Open Modal" close_button="yes" modal_title="Modal Title" title_color="#fff" color="#fff" background="#1abc9c" overlay_background="rgba(0, 0, 0,0.3)" shadow="none" border="none" radius="3"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_modal][/wps_clipboard][wps_spacer size="15"][wps_modal effect="1" button_text="Open Modal" close_button="yes" modal_title="Modal Title" title_color="#fff" color="#fff" background="#1abc9c" overlay_background="rgba(0, 0, 0,0.3)" shadow="none" border="none" radius="3"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_modal][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Social Share</h3>[wps_clipboard][wps_social_share services="facebook,twitter,google-plus,pinterest,tumblr"][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-1" center="yes"][wps_social_share services="facebook,twitter,google-plus,linkedin,pinterest,stumbleupon,tumblr,telegram"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Photo Panel</h3>[wps_clipboard][wps_photo_panel background="#f5f5f5" color="#444444" photo="https://demo.mythemeshop.com/dividend/files/2014/06/pexels-photo-91483-1026x500.jpeg" align="left" radius="0" shadow="0px 0px 15px #333333" border="0px solid #000000" url="https://demo.mythemeshop.com/wp-real-estate-pro/feed/"]Left aligned[/wps_photo_panel][/wps_clipboard][wps_spacer size="15"][wps_row size="1/2" center="no"][wps_column size="1-2" center="no"][wps_photo_panel background="#f5f5f5" color="#444444" photo="https://demo.mythemeshop.com/dividend/files/2014/06/pexels-photo-91483-1026x500.jpeg" align="left" radius="0" shadow="0px 0px 15px #333333" border="0px solid #000000" url="https://demo.mythemeshop.com/wp-real-estate-pro/feed/"]Left aligned[/wps_photo_panel][/wps_column][wps_column size="1-2" center="no"][wps_photo_panel background="#4fbcae" color="#ffffff" photo="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-160150-1026x500.jpeg" align="center" radius="0" shadow="0px 0px 15px #333333" border="0px solid #000000" url="https://demo.mythemeshop.com/wp-real-estate-pro/feed/"]Right aligned[/wps_photo_panel][/wps_column][/wps_row][wps_row][wps_column size="1-2" center="no"][wps_photo_panel background="#418cd8" color="#ffffff" photo="https://demo.mythemeshop.com/dividend/files/2015/12/pexels-photo-101983.jpeg" align="center" radius="0" shadow="0px 0px 15px #333333" border="0px solid #000000" url="https://demo.mythemeshop.com/wp-real-estate-pro/feed/"]Centered Image[/wps_photo_panel][/wps_column][wps_column size="1-2" center="no"][wps_photo_panel background="#cc2e2e" color="#ffffff" photo="https://demo.mythemeshop.com/dividend/files/2015/12/pexels-photo-25877-1026x500.jpg" align="center" radius="3" shadow="0px 0px 0px #333333" border="2px solid #aeaeae"]Image with border and radius[/wps_photo_panel][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Splash Screen</h3>[wps_clipboard][wps_splash_screen title="Splash Screen Title" width="500px" height="500px" radius="0" shadow="0px 0px 15px #4e8abf" border="1px solid #4e8abf" background="#2575ed" color="#fff" overlay_bg="#7a7a7a" opacity="40" delay="0" close="yes" esc="yes" onclick="no"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_splash_screen][/wps_clipboard][wps_spacer size="15"][wps_splash_screen title="Splash Screen Title" width="500px" height="500px" radius="0" shadow="0px 0px 15px #4e8abf" border="1px solid #4e8abf" background="#2575ed" color="#fff" overlay_bg="#7a7a7a" opacity="40" delay="0" close="yes" esc="yes" onclick="no"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_splash_screen]Use this shortcode to display splash popup[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Compare Image</h3>[wps_clipboard][wps_compare_image orientation="horizontal" before_label="Before" before_image="https://demo.mythemeshop.com/dividend/files/2014/06/pexels-photo-91483-1026x500.jpeg" after_label="After" after_image="https://demo.mythemeshop.com/dividend/files/2015/12/pexels-photo-103681-1026x500.jpeg"][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-1" center="yes"]<strong>Horizontal</strong>[wps_compare_image orientation="horizontal" before_label="Before" before_image="https://demo.mythemeshop.com/dividend/files/2014/06/pexels-photo-91483-1026x500.jpeg" after_label="After" after_image="https://demo.mythemeshop.com/dividend/files/2015/12/pexels-photo-103681-1026x500.jpeg"][wps_row][wps_column size="1-1" center="yes"]<strong>Vertical</strong>[wps_compare_image orientation="vertical" before_label="Before" before_image="https://demo.mythemeshop.com/dividend/files/2014/06/pexels-photo-91483-1026x500.jpeg" after_label="After" after_image="https://demo.mythemeshop.com/dividend/files/2015/12/pexels-photo-103681-1026x500.jpeg"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Slider</h3>[wps_clipboard][wps_slider source="posts-recent" limit="10" link="lightbox" target="self" width="600" height="300" title="yes" arrows="1" pager="1" gallery="1" autoplay="5000" speed="600"][/wps_clipboard][wps_spacer size="15"]<strong></strong>[wps_slider source="posts-recent" limit="10" link="lightbox" target="self" width="600" height="300" title="yes" arrows="1" pager="1" gallery="1" autoplay="5000" speed="600"][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Content Slider</h3>[wps_clipboard][wps_content_slider style="light" animatein="slideInLeft" animateout="slideOutRight" autoplay="1" arrows="1" arrow_position="center" pagination="1" pagination_position="bottom-middle"][wps_content_slide]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum[/wps_content_slide][wps_content_slide]At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus[/wps_content_slide][wps_content_slide]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet [/wps_content_slide][/wps_content_slider][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-2" center="no"]<strong>Light Slider</strong>[wps_content_slider style="light" animatein="slideInLeft" animateout="slideOutRight" autoplay="1" arrows="1" arrow_position="center" pagination="1" pagination_position="bottom-middle"][wps_content_slide]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum[/wps_content_slide][wps_content_slide]At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus[/wps_content_slide][wps_content_slide]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet [/wps_content_slide][/wps_content_slider][/wps_column][wps_column size="1-2" center="no"]<strong>Dark Slider</strong>[wps_content_slider style="dark" animatein="fadeIn" animateout="fadeOut" autoplay="1" arrows="1" arrow_position="top-right" pagination="0"][wps_content_slide]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum[/wps_content_slide][wps_content_slide]At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus[/wps_content_slide][wps_content_slide]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet [/wps_content_slide][/wps_content_slider][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Animation</h3>[wps_clipboard][wps_animate type="bounceIn" duration="1" delay="0" inline="no"]Animated content[/wps_animate][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size='1-5' center='no'][wps_animate type="bounceIn" duration="1" delay="0" inline="no"]Animated content[/wps_animate][/wps_column][wps_column size='1-5' center='no'][wps_animate type="rotateIn" duration="1" delay="0" inline="no"]Animated content[/wps_animate][/wps_column][wps_column size='1-5' center='no'][wps_animate type="rollIn" duration="1" delay="2" inline="no"]Animated content[/wps_animate][/wps_column][wps_column size='1-5' center='no'][wps_animate type="flipInY" duration="1" delay="1.5" inline="no"]Animated content[/wps_animate][/wps_column][wps_column size='1-5' center='no'][wps_animate type="slideInLeft" duration="1" delay="2" inline="no"]Animated content[/wps_animate][/wps_column][/wps_row]<strong></strong>[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>FlipBox</h3>[wps_clipboard][wps_flip_box animation="basic" align="center"][wps_flip_front ff_background="#81d742" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#dd3333" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-4"][wps_flip_box animation="basic" align="center"][wps_flip_front ff_background="#81d742" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#dd3333" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_column][wps_column size="1-4"][wps_flip_box animation="flip_left" align="center"][wps_flip_front ff_background="#23b8dd" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#1e73be" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_column][wps_column size="1-4"][wps_flip_box animation="flip_right" align="center"][wps_flip_front ff_background="#dd3333" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#f40051" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_column][wps_column size="1-4"][wps_flip_box animation="flip_left" align="center"][wps_flip_front ff_background="#11e0bd" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#d8a311" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_column][/wps_row][wps_row][wps_column size="1-4"][wps_flip_box animation="flip_top" align="center"][wps_flip_front ff_background="#d8a311" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#11e0bd" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_column][wps_column size="1-4"][wps_flip_box animation="flip_bottom" align="center"][wps_flip_front ff_background="#f40051" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#dd3333" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_column][wps_column size="1-4"][wps_flip_box animation="vertical_flip_bottom" align="center"][wps_flip_front ff_background="#1e73be" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#23b8dd" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_column][wps_column size="1-4"][wps_flip_box animation="vertical_flip_top" align="center"][wps_flip_front ff_background="#dd3333" ff_color="#ffffff" ff_padding="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_flip_front][wps_flip_back fb_background="#81d742" fb_color="#ffffff" fb_padding="20px"]Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi option[/wps_flip_back][/wps_flip_box][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Overlay</h3>[wps_clipboard][wps_overlay image="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-393407-285x240.jpeg" style="style-1" title="Test title"]Lorem ipsum dolor sit ame[/wps_overlay][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-3"][wps_overlay image="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-393407-285x240.jpeg" style="style-1" title="Test title"]Lorem ipsum dolor sit ame[/wps_overlay][/wps_column][wps_column size="1-3"][wps_overlay image="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-393407-285x240.jpeg" style="style-2" title="Test title"]Lorem ipsum dolor sit ame[/wps_overlay][/wps_column][wps_column size="1-3"][wps_overlay image="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-393407-285x240.jpeg" style="style-3" title="Test title"]Lorem ipsum dolor sit ame[/wps_overlay][/wps_column][/wps_row][wps_row][wps_column size="1-3"][wps_overlay image="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-393407-285x240.jpeg" style="style-4" title="Test title"]Lorem ipsum dolor sit ame[/wps_overlay][/wps_column][wps_column size="1-3"][wps_overlay image="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-393407-285x240.jpeg" style="style-5" title="Test title"]Lorem ipsum dolor sit ame[/wps_overlay][/wps_column][wps_column size="1-3"][wps_overlay image="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-393407-285x240.jpeg" style="style-6" title="Test title"]Lorem ipsum dolor sit ame[/wps_overlay][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Shadow</h3>[wps_row][wps_column size="1-2" center="no"]<strong>Vertical</strong>[wps_clipboard][wps_shadow style="default"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[/wps_shadow][/wps_clipboard][wps_spacer size="15"][wps_shadow style="default"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[/wps_shadow][/wps_column][wps_column size="1-2" center="no"]<strong>Horizontal</strong>[wps_clipboard][wps_shadow style="horizontal"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[/wps_shadow][/wps_clipboard][wps_spacer size="15"][wps_shadow style="horizontal"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[/wps_shadow][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Table</h3>[wps_clipboard][wps_table style="default"]&lt;table&gt;&lt;thead&gt;&lt;tr&gt;&lt;th&gt;&lt;/th&gt;&lt;th&gt;&lt;/th&gt;&lt;th&gt;&lt;/th&gt;&lt;th&gt;&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;[/wps_table][/wps_clipboard][wps_table style="default"]<table><thead><tr class="ui-sortable"><th class="wps-sort-row ui-sortable-handle">C1</th><th class="wps-sort-row ui-sortable-handle">C2</th><th class="wps-sort-row ui-sortable-handle">C3</th><th class="wps-sort-row ui-sortable-handle">C4</th></tr></thead><tbody><tr><td>Lorem ipsum dolor</td><td>Sed ut perspiciatis</td><td>Lorem ipsum dolor</td><td>Sed ut perspiciatis</td></tr><tr><td>Sed ut perspiciatis</td><td>Lorem ipsum dolor</td><td>Sed ut perspiciatis</td><td>Lorem ipsum dolor</td></tr><tr><td>Lorem ipsum dolor</td><td>Sed ut perspiciatis</td><td>Lorem ipsum dolor</td><td>Sed ut perspiciatis</td></tr><tr><td>Sed ut perspiciatis</td><td>Lorem ipsum dolor</td><td>Sed ut perspiciatis</td><td>Lorem ipsum dolor</td></tr><tr><td>Lorem ipsum dolor</td><td>Sed ut perspiciatis</td><td>Lorem ipsum dolor</td><td>Sed ut perspiciatis</td></tr></tbody></table>[/wps_table][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Pricing Table</h3>[wps_clipboard][wps_pricing_table style="style-4"][wps_plan title="Basic" currency="$" price="99" period="/month" background="#29c4c1" color="#ffffff" featured="no" icon="home" button_text="Sign Up Now" button_background="#141414" button_color="#ffffff" target="blank"]<ul> <li>Vitae adipiscing turpis. Aenean ligula nibh, molestie id vivide.</li><li>Option-1</li><li>Option-2</li><li>Option-3</li><li>Option-4</li><li>Option-5</li></ul>[/wps_plan][wps_plan title="Premium" currency="$" price="99" period="/month" background="#f40051" color="#ffffff" featured="featured" icon="credit-card" icon_color="#ffffff" button_text="Sign Up Now" button_background="#141414" button_color="#ffffff" target="blank"]<ul> <li>Vitae adipiscing turpis. Aenean ligula nibh, molestie id vivide.</li><li>Option-1</li><li>Option-2</li><li>Option-3</li><li>Option-4</li><li>Option-5</li></ul>[/wps_plan][wps_plan title="Gold" currency="$" price="99" period="/month" background="#11e0bd" color="#ffffff" featured="no" icon="paper-plane" icon_color="#ffffff" button_text="Sign Up Now" button_background="#141414" button_color="#ffffff" target="blank"]<ul> <li>Vitae adipiscing turpis. Aenean ligula nibh, molestie id vivide.</li><li>Option-1</li><li>Option-2</li><li>Option-3</li><li>Option-4</li><li>Option-5</li></ul>[/wps_plan][/wps_pricing_table][/wps_clipboard][wps_spacer size="15"][wps_pricing_table style="style-4"][wps_plan title="Basic" currency="$" price="99" period="/month" background="#29c4c1" color="#ffffff" featured="no" icon="home" button_text="Sign Up Now" button_background="#141414" button_color="#ffffff" target="blank"]<ul> <li>Vitae adipiscing turpis. Aenean ligula nibh, molestie id vivide.</li><li>Option-1</li><li>Option-2</li><li>Option-3</li><li>Option-4</li><li>Option-5</li></ul>[/wps_plan][wps_plan title="Premium" currency="$" price="99" period="/month" background="#f40051" color="#ffffff" featured="featured" icon="credit-card" icon_color="#ffffff" button_text="Sign Up Now" button_background="#141414" button_color="#ffffff" target="blank"]<ul> <li>Vitae adipiscing turpis. Aenean ligula nibh, molestie id vivide.</li><li>Option-1</li><li>Option-2</li><li>Option-3</li><li>Option-4</li><li>Option-5</li></ul>[/wps_plan][wps_plan title="Gold" currency="$" price="99" period="/month" background="#11e0bd" color="#ffffff" featured="no" icon="paper-plane" icon_color="#ffffff" button_text="Sign Up Now" button_background="#141414" button_color="#ffffff" target="blank"]<ul> <li>Vitae adipiscing turpis. Aenean ligula nibh, molestie id vivide.</li><li>Option-1</li><li>Option-2</li><li>Option-3</li><li>Option-4</li><li>Option-5</li></ul>[/wps_plan][/wps_pricing_table][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>FAQ</h3>[wps_clipboard][wps_faq question="Lorem ipsum dolor sit amet, consectetur adipiscing elit?" icon="question"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur[/wps_faq][wps_faq question="Lorem ipsum dolor sit amet, consectetur adipiscing elit?" icon="question"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur[/wps_faq][/wps_clipboard][wps_spacer size="15"][wps_faq question="Lorem ipsum dolor sit amet, consectetur adipiscing elit?" icon="question"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur[/wps_faq][wps_faq question="Lorem ipsum dolor sit amet, consectetur adipiscing elit?" icon="question"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur[/wps_faq][wps_faq question="Lorem ipsum dolor sit amet, consectetur adipiscing elit?" icon="question"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur[/wps_faq][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>QR Code</h3>[wps_clipboard][wps_qrcode data="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." title="Scan QR Code" size="200" margin="0" align="none" target="blank" color="#000000" background="#ffffff"][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-3" center="yes"][wps_qrcode data="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." title="Scan QR Code" size="200" margin="0" align="none" target="blank" color="#000000" background="#ffffff"][/wps_column][wps_column size="1-3" center="yes"][wps_qrcode data="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." title="Scan QR Code" size="200" margin="0" align="none" target="blank" color="#1e73be" background="#ffffff"][/wps_column][wps_column size="1-3" center="yes"][wps_qrcode data="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." title="Scan QR Code" size="200" margin="0" align="none" target="blank" color="#dd3833" background="#0c0c0c"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][wps_row][wps_column size="1-2"]<h3>Google Map</h3>[wps_clipboard][wps_google_map width="600" height="400" address="Libertyville, Illinois, USA"][/wps_clipboard][wps_spacer size="15"][wps_google_map width="600" height="400" address="Libertyville, Illinois, USA"][/wps_column][wps_column size="1-2"]<h3>Advanced Google Map</h3>[wps_clipboard][wps_advanced_google_map style="light-gray" width="400" height="200" zoom="12" fit="yes" marker_image="https://demo.mythemeshop.com/wp-real-estate-pro/files/2018/03/wrel-green-marker.png" addresses="35.6914327/-100.63819330000001,39.7392358/-104.990251,29.3708857/-100.89586739999999" search="yes" search_zoom="12"][/wps_clipboard][wps_spacer size="15"][wps_advanced_google_map style="light-gray" width="500" height="300" zoom="12" fit="yes" marker_image="https://demo.mythemeshop.com/wp-real-estate-pro/files/2018/03/wrel-green-marker.png" addresses="35.6914327/-100.63819330000001,39.7392358/-104.990251,29.3708857/-100.89586739999999" search="yes" search_zoom="12"][/wps_column][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][/wps_row]<h3>Google Trends</h3>[wps_clipboard][wps_google_trends query="wordpress,theme,plugin" geo="US"][/wps_clipboard][wps_spacer size="15"][wps_google_trends query="wordpress,theme,plugin" geo="US"][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Pie Chart</h3>[wps_clipboard][wps_pie_chart columns="Task | Hours per Day" rows="Work, 11 | Sleep, 7 | Eat, 2 | Commute, 3" is3d="0" width="500" height="300"][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size="1-2"]<strong>Normal Chart</strong>[wps_pie_chart columns="Task | Hours per Day" rows="Work, 11 | Sleep, 7 | Eat, 2 | Commute, 3" is3d="0" width="500" height="300"][/wps_column][wps_column size="1-2"]<strong>3D Chart</strong>[wps_pie_chart columns="Task | Hours per Day" rows="Work, 11 | Sleep, 7 | Eat, 2 | Commute, 3" is3d="1" width="500" height="300"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][wps_row][wps_column size="1-2"]<h3>Combo Chart</h3>[wps_clipboard][wps_combo_chart columns="Month | Bolivia | Ecuador | Madagascar | Papua New Guinea | Rwanda | Average" rows="2004/05, 165, 938, 522, 998, 450,614.6 | 2004/05, 135, 1120, 599, 1268, 288,682 | 2005/06, 157, 1167, 587, 807, 397,623 | 2006/07, 139, 1110, 615, 968, 215,609.4 | 2008/09, 136, 691, 629, 1026, 366,569.6" vaxis="Cups" haxis="Month" width="500" height="300"][/wps_clipboard][wps_spacer size="15"][wps_combo_chart columns="Month | Bolivia | Ecuador | Madagascar | Papua New Guinea | Rwanda | Average" rows="2004/05, 165, 938, 522, 998, 450,614.6 | 2004/05, 135, 1120, 599, 1268, 288,682 | 2005/06, 157, 1167, 587, 807, 397,623 | 2006/07, 139, 1110, 615, 968, 215,609.4 | 2008/09, 136, 691, 629, 1026, 366,569.6" vaxis="Cups" haxis="Month" width="500" height="300"][/wps_column][wps_column size="1-2"]<h3>Bar Chart</h3>[wps_clipboard][wps_bar_chart columns="Galaxy | Distance | Brightness" rows="Canis Major Dwarf, 8000, 23.3 | Sagittarius Dwarf, 24000, 4.5 | Ursa Major II Dwarf, 30000, 14.3 | Lg. Magellanic Cloud, 50000, 0.9" xaxis_top="apparent magnitude" xaxis_bottom="Amount" width="500" height="300"][/wps_clipboard][wps_spacer size="15"][wps_bar_chart columns="Galaxy | Distance | Brightness" rows="Canis Major Dwarf, 8000, 23.3 | Sagittarius Dwarf, 24000, 4.5 | Ursa Major II Dwarf, 30000, 14.3 | Lg. Magellanic Cloud, 50000, 0.9" xaxis_top="apparent magnitude" xaxis_bottom="Amount" width="500" height="300"][/wps_column][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][/wps_row][wps_row][wps_column size="1-2"]<h3>Area Chart</h3>[wps_clipboard][wps_area_chart columns="Year | Sales | Expenses" rows="2013, 1000, 400 | 2014, 1170, 460 | 2015, 660, 1120 | 2016, 1030, 540" vaxis="Amount" haxis="Year" width="500" height="300"][/wps_clipboard][wps_spacer size="15"][wps_area_chart columns="Year | Sales | Expenses" rows="2013, 1000, 400 | 2014, 1170, 460 | 2015, 660, 1120 | 2016, 1030, 540" vaxis="Amount" haxis="Year" width="500" height="300"][/wps_column][wps_column size="1-2"]<h3>Org Chart</h3>[wps_clipboard][wps_org_chart size="medium" columns="Name | Position | Tooltip" rows="Mike,null,President | Jane, Mike, Vice President | Carol, Mike, Co-founder | Ron, Mike, Co-founder | Carol, Mike, Co-founder | Keith, Carol, Manager | Employee1, Keith, Emplyee | Employee2, Keith, Emplyee | Employee3, Keith, Emplyee"][/wps_clipboard][wps_spacer size="15"][wps_org_chart size="medium" columns="Name | Position | Tooltip" rows="Mike,null,President | Jane, Mike, Vice President | Carol, Mike, Co-founder | Ron, Mike, Co-founder | Carol, Mike, Co-founder | Keith, Carol, Manager | Employee1, Keith, Emplyee | Employee2, Keith, Emplyee | Employee3, Keith, Emplyee"][/wps_column][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][/wps_row][wps_row][wps_column size="1-2"]<h3>Bubble Chart</h3>[wps_clipboard][wps_bubble_chart columns="ID | X | Y | Temperature" rows="null, 80, 167, 120 | null, 79, 136, 130 | null, 78, 184, 50 | null, 72, 278, 230 | null, 81, 200, 210 | null, 72, 170, 100 | null, 68, 477, 80" vaxis="Cups" haxis="Month" primary_color="#999999" secondary_color="#999999" width="500" height="300"][/wps_clipboard][wps_spacer size="15"][wps_bubble_chart columns="ID | X | Y | Temperature" rows="null, 80, 167, 120 | null, 79, 136, 130 | null, 78, 184, 50 | null, 72, 278, 230 | null, 81, 200, 210 | null, 72, 170, 100 | null, 68, 477, 80" vaxis="Cups" haxis="Month" primary_color="#999999" secondary_color="#999999" width="500" height="300"][/wps_column][wps_column size="1-2"]<h3>Geo Chart</h3>[wps_clipboard][wps_geo_chart columns="Country | Popularity" rows="Germany, 150 | US, 200 | UK, 250 | China, 100" width="500" height="300"][/wps_clipboard][wps_spacer size="15"][wps_geo_chart columns="Country | Popularity" rows="Germany, 150 | US, 200 | UK, 250 | China, 100" width="500" height="300"][/wps_column][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][/wps_row][wps_row][wps_column size="1-2"]<h3>Document</h3>[wps_clipboard][wps_document url="http://unec.edu.az/application/uploads/2014/12/pdf-sample.pdf" width="600" height="600" responsive="yes"][/wps_clipboard][wps_spacer size="15"][wps_document url="http://unec.edu.az/application/uploads/2014/12/pdf-sample.pdf" width="600" height="600" responsive="yes"][/wps_column][wps_column size="1-2"]<h3>Timeline</h3>[wps_clipboard][wps_timeline limit="7" align="left"][/wps_clipboard][wps_spacer size="15"][wps_timeline limit="7" align="left"][/wps_column][/wps_row]<h3>Section</h3>[wps_clipboard][wps_section size="full-boxed" height="500px" background="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-160150-1026x500.jpeg" background_size="cover" background_repeat="no-repeat" background_mode="fixed" align_content_vertical="center" align="left" content_width="400px" content_bg="#d8d8d8" content_color="#444" padding="30" margin="20"]Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.[/wps_section][/wps_clipboard][wps_spacer size="15"]<strong>Section with Background Image</strong>[wps_section size="full-boxed" height="500px" background="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-160150-1026x500.jpeg" background_size="cover" background_repeat="no-repeat" background_mode="fixed" align_content_vertical="center" align="left" content_width="400px" content_bg="#d8d8d8" content_color="#444" padding="30" margin="20"]Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.[/wps_section]<strong>Parallax Section</strong>[wps_section size="full-boxed" height="400px" background="https://demo.mythemeshop.com/dividend/files/2017/08/pexels-photo-160150-1026x500.jpeg" background_size="cover" background_repeat="no-repeat" background_mode="parallax" align_content_vertical="center" align="left" content_width="400px" content_bg="#d8d8d8" content_color="#444" padding="30" margin="20"]Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.[/wps_section][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Exit Popup</h3>[wps_clipboard][wps_exit_popup title="Exit Popup Title" width="500px" height="500px" radius="0" shadow="0px 0px 15px #333333" border="3px solid #ffffff" background="#db7532" color="#ffffff" opacity="40" delay="0" close="yes" esc="yes" onclick="no"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_exit_popup][/wps_clipboard][wps_spacer size="15"][wps_exit_popup title="Exit Popup Title" width="500px" height="500px" radius="0" shadow="0px 0px 15px #333333" border="3px solid #ffffff" background="#db7532" color="#ffffff" opacity="40" delay="0" close="yes" esc="yes" onclick="no"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.[/wps_exit_popup]Exit Popup intelligently detects the mouse behaviors and then pops up a modal window when your visitors are about to close the current webpage, helping you increase your landing page conversion rates, newsletter subscribers and so on.[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Exit Bar</h3>[wps_clipboard][wps_exit_bar title="Exit Bar Title" background="#db8632" color="#ffffff" close="yes"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et[/wps_exit_bar][/wps_clipboard][wps_spacer size="15"][wps_exit_bar title="Exit Bar Title" background="#db8632" color="#ffffff" close="yes"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et.[/wps_exit_bar]Exit Bar intelligently detects the mouse behaviors and then pops up a modal window when your visitors are about to close the current webpage, helping you increase your landing page conversion rates, newsletter subscribers and so on.[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>FlyOut</h3>[wps_clipboard][wps_flyout position="bottom-right" dimensions="250x250" transitionin="slideInLeft" transitionout="slideOutRight" enable_close="1" close_style="box" background="#4b98fc" color="#ffffff" shadow="0px 0px 0px #000000" border="0px solid #000000" radius="0" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation[/wps_flyout][/wps_clipboard][wps_spacer size="15"][wps_flyout position="bottom-right" dimensions="250x250" transitionin="slideInLeft" transitionout="slideOutRight" enable_close="1" close_style="box" background="#4b98fc" color="#ffffff" shadow="0px 0px 0px #000000" border="0px solid #000000" radius="0" target="blank"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation[/wps_flyout][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][wps_row][wps_column size="1-2"]<h3>Dummy Text</h3>[wps_clipboard][wps_dummy_text what="paras" amount="1"][/wps_clipboard][wps_spacer size="15"][wps_dummy_text what="paras" amount="1"][/wps_column][wps_column size="1-2"]<h3>Dummy Image</h3>[wps_clipboard][wps_dummy_image width="500" height="300" theme="abstract"][/wps_clipboard][wps_spacer size="15"][wps_dummy_image width="500" height="300" theme="abstract"][/wps_column][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][/wps_row][wps_row][wps_column size="1-2"]<h3>Youtube</h3>[wps_clipboard][wps_youtube url="https://www.youtube.com/watch?v=ilk58Gfxcg0" width="600" height="400" responsive="yes" autoplay="no"][/wps_clipboard][wps_spacer size="15"][wps_youtube url="https://www.youtube.com/watch?v=ilk58Gfxcg0" width="600" height="400" responsive="yes" autoplay="no"][/wps_column][wps_column size="1-2"]<h3>Youtube Advanced</h3>[wps_clipboard][wps_youtube_advanced url="https://www.youtube.com/watch?v=ilk58Gfxcg0" playlist="6fNqDL8Zfmk, nF4LjluBcA4, _p8YPNTOILY" width="600" height="400" controls="yes" autohide="alt" showinfo="yes" autoplay="no" loop="no" rel="yes" fs="yes" modestbranding="no" responsive="yes" https="no" wmode="transparent"][/wps_clipboard][wps_spacer size="15"][wps_youtube_advanced url="https://www.youtube.com/watch?v=ilk58Gfxcg0" playlist="6fNqDL8Zfmk, nF4LjluBcA4, _p8YPNTOILY" width="600" height="400" controls="yes" autohide="alt" showinfo="yes" autoplay="no" loop="no" rel="yes" fs="yes" modestbranding="no" responsive="yes" https="no" wmode="transparent"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Vimeo</h3>[wps_clipboard][wps_vimeo url="https://vimeo.com/93848479" width="600" height="400" responsive="yes" autoplay="no"][/wps_clipboard][wps_spacer size="15"][wps_row][wps_column size='1-1' center='yes'][wps_vimeo url="https://vimeo.com/93848479" width="600" height="400" responsive="yes" autoplay="no"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"][wps_row][wps_column size="1-2"]<h3>Video</h3>[wps_clipboard][wps_video url="http://techslides.com/demos/sample-videos/small.mp4" title="Player title" width="100%" height="" controls="yes" autoplay="no" loop="no"][/wps_clipboard][wps_spacer size="15"][wps_video url="http://techslides.com/demos/sample-videos/small.mp4" title="Player title" width="100%" height="" controls="yes" autoplay="no" loop="no"][/wps_column][wps_column size="1-2"]<h3>Audio</h3>[wps_clipboard][wps_audio url="https://ia802508.us.archive.org/5/items/testmp3testfile/mpthreetest.mp3" width="100%" autoplay="no" loop="no"][/wps_clipboard][wps_spacer size="15"][wps_audio url="https://ia802508.us.archive.org/5/items/testmp3testfile/mpthreetest.mp3" width="100%" autoplay="no" loop="no"][/wps_column][/wps_row][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Responsive Utility</h3>[wps_clipboard][wps_responsive_utility visible="extra-large" hidden="extra-large"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/wps_responsive_utility][/wps_clipboard][wps_spacer size="15"]<div class="wps-notice">The Responsive Utility Shortcode gives you the ability to hide or show elements on the page responsively for different device sizes.</div><div><section id="content-section-1602915645" class="intense content-section "><div class="intense container "><strong>*resize your browser window to see the Responsive Utility shortcode in action.</strong></div></section></div><div>[wps_row][wps_column size='1-4' center='no'][wps_responsive_utility visible="extra-large" hidden=""]Extra Large Device (&gt;=1200)[/wps_responsive_utility][/wps_column][wps_column size='1-4' center='no'][wps_responsive_utility visible="large" hidden="extra-large"]Large Device (&gt;=992)[/wps_responsive_utility][/wps_column][wps_column size='1-4' center='no'][wps_responsive_utility visible="medium" hidden="large"]Medium Device (&gt;=768)[/wps_responsive_utility][/wps_column][wps_column size='1-4' center='no'][wps_responsive_utility visible="small" hidden="medium"]Small Device (&gt;=544)[/wps_responsive_utility][/wps_column][/wps_row]</div>[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Permalink</h3>[wps_clipboard][wps_permalink id="1" target="self"][/wps_permalink][/wps_clipboard][wps_spacer size="15"][wps_permalink id="1" target="self"][/wps_permalink][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Private Note</h3>[wps_clipboard][wps_private_note]Private note text[/wps_private_note][/wps_clipboard][wps_spacer size="15"]<div class="wps-notice">You can use this shortcode to show private note to post author.</div>[wps_private_note]Private note text[/wps_private_note][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Members</h3>[wps_clipboard][wps_members message="You need to %login% to view this content." color="#444" login_text="login" login_url="http://localhost/theme-review/wp-login.php"]Content for logged members[/wps_members][/wps_clipboard][wps_spacer size="15"][wps_members message="You need to %login% to view this content." color="#444" login_text="login" login_url="http://localhost/theme-review/wp-login.php"]Content for logged members[/wps_members][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Guests</h3>[wps_clipboard][wps_guests]This content will be available only for non-logged visitors[/wps_guests][/wps_clipboard][wps_spacer size="15"][wps_guests]This content will be available only for non-logged visitors[/wps_guests]You can use this shortcode to show different content to non-logged users.[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Post data</h3>[wps_clipboard][wps_post field="post_title" default="Post does not exits" before="Title: " post_id="1"][/wps_clipboard][wps_spacer size="15"][wps_post field="post_title" default="Post does not exits" before="Title: " post_id="1"][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Post meta</h3>[wps_clipboard][wps_meta key="price" default="$40" before="Price: " after="/year" post_id="1"][/wps_clipboard][wps_spacer size="15"][wps_meta key="price" default="$40" before="Price: " after="/year" post_id="1"][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Posts block</h3>[wps_clipboard][wps_posts_block post_type="post" taxonomy="category" tax_term="" tax_operator="IN" offset="0" post_status="publish" excerpt_length="30" view="grid" columns="2" ignore_sticky_posts="no" order="desc" orderby="date" posts_per_page="4" allow_pagination="no"][/wps_clipboard][wps_spacer size="15"][wps_posts_block post_type="post" taxonomy="category" tax_term="" tax_operator="IN" offset="0" post_status="publish" excerpt_length="30" view="grid" columns="2" ignore_sticky_posts="no" order="desc" orderby="date" posts_per_page="4" allow_pagination="no"][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>User data</h3>[wps_clipboard][wps_user field="display_name" default="User does not exists." before="Name: " user_id="1"][/wps_clipboard][wps_spacer size="15"][wps_user field="display_name" default="User does not exists." before="Name: " user_id="1"][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Siblings</h3>[wps_clipboard][wps_siblings depth="2"][/wps_clipboard][wps_spacer size="15"][wps_siblings depth="2"]*<strong>Use this shortcode to show siblings of current page.</strong>[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Subpages</h3>[wps_clipboard][wps_subpages depth="1" parent="1"][/wps_clipboard][wps_spacer size="15"][wps_subpages depth="1" parent="1"]*<strong>Use this shortcode to show subpages of current page.</strong>[wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]<h3>Spacer/Separator</h3>[wps_clipboard][wps_spacer size="30"][wps_separator top="yes" text="Top" style="double" separator_color="#444" link_color="#444" size="8" margin="30"][/wps_clipboard][wps_spacer size="15"][wps_spacer size="30"][wps_separator top="yes" text="Top" style="double" separator_color="#444" link_color="#444" size="8" margin="0"][wps_spacer size="50"][wps_separator top="no" style="default" separator_color="#444444" size="2" margin="0"][wps_spacer size="50"]
		</div>
		<?php
		$content = ob_get_clean();
		$content =  str_replace('wps_', $prefix, $content);
		return $content;
	}

	/**
	 * Get settings keys
	 * @return array
	 */
	public function get_keys() {
		return $this->keys;
	}

	/**
	 * Get Setting
	 *
	 * @param string $field_id
	 * @param mixed  $default
	 *
	 * @return mixed
	 */
	public function get( $field_id = '', $default = false ) {

		$ids  = explode( '.', $field_id );
		$opts = $this->get_options();

		foreach ( $ids as $id ) {
			if ( is_null( $opts ) ) {
				break;
			}
			$opts = isset( $opts[ $id ] ) ? $opts[ $id ] : null;
		}

		if ( is_null( $opts ) ) {
			return $default;
		}

		return false !== $opts ? $opts : $default;
	}

	/**
	 * Get all settings
	 *
	 * @return array
	 */
	public function all() {
		return $this->get_options();
	}

	/**
	 * Get options once for use throughout the plugin cycle
	 *
	 * @return void
	 */
	public function get_options() {

		if ( is_null( $this->options ) && ! empty( $this->keys ) ) {

			$options = array();
			foreach ( $this->keys as $id => $key ) {
				$options[ $id ] = get_option( $key, array() );
			}

			$this->options = $this->normalize_it( $options );
		}

		return (array) $this->options;
	}

	/**
	 * Add new option page
	 * @param void
	 */
	public function add_options( $id, $key ) {

		if ( ! empty( $id ) && ! empty( $key ) ) {

			$this->keys[ $id ] = $key;

			// Lazy-Load options
			if ( ! is_null( $this->options ) ) {
				$options = get_option( $key, array() );
				$options = $this->normalize_it( $options );

				$this->options[ $id ] = $options;
			}
		}
	}

	/**
	 * Normalize option data
	 * @param  mixed $value
	 * @return mixed
	 */
	private function normalize_it( $options ) {

		foreach ( $options as $key => $value ) {
			$options[ $key ] = is_array( $value ) ? $this->normalize_it( $value ) : $this->normalize_data( $value );
		}

		return $options;
	}

	/**
	 * Normalize option value
	 *
	 * @param  mixed $value
	 * @return mixed
	 */
	private function normalize_data( $value ) {

		if ( 'true' === $value || 'on' === $value ) {
			$value = true;
		} elseif ( 'false' === $value || 'off' === $value ) {
			$value = false;
		} elseif ( '0' === $value || '1' === $value ) {
			$value = intval( $value );
		}

		return $value;
	}

	public function wps_get_settings_callback() {
		$selected_values = $_POST['selected'];
		$data = array();
		if(in_array('presets', $selected_values)) {
			$data['presets'] = $this->get_presets();
		}
		if(in_array('shortcodes', $selected_values)) {
			$data['custom_shortcodes'] = wp_shortcode()->create_shortcode->get_custom_shortcode_details();
		}
		if(in_array('mapped_shortcodes', $selected_values)) {
			$data['mapped_shortcodes'] = $this->get_mapped_shortcodes();
		}
		echo wp_json_encode($data);
		die();
	}

	public function wps_import_settings_callback($import) {

		$settings = json_decode($import, true);

		if( ! empty($settings['presets']) ) {
			foreach( $settings['presets'] as $setting ) {
				update_option( $setting['option_name'], unserialize($setting['option_value']) );
			}
			$flag = true;
		}
		if(!empty($settings['mapped_shortcodes'])) {
			update_option('wps_mapper', $settings['mapped_shortcodes']);
		}
		if(!empty($settings['custom_shortcodes'])) {
			$custom_shortcodes = $settings['custom_shortcodes'];
			foreach($custom_shortcodes as $shortcode_name => $shortcode) {

				$args = array(
					'post_title'	=> wp_strip_all_tags($shortcode['name']),
					'post_name'		=> $shortcode_name,
					'post_status'	=> 'publish',
					'post_type'		=> 'wp_custom_shortcodes'
				);
				unset($shortcode['name']);
				$shortcode_id = wp_insert_post($args);
				update_post_meta($shortcode_id, '_wps_details', $shortcode);
			}
		}
	}

	/**
	 * Download the options file, or display it
	 *
	 * @since WP_Shortcode_Settings 1.0
	 */
	function wps_download_settings() {
		if ( ! wp_verify_nonce( $_GET['_wpnonce'], 'wps_export' ) ) {
			die( '0' );
		}

		if(!empty($_GET['export'])) {
			$settings = array();

			$export = explode(',', $_GET['export']);

			if(in_array('presets', $export)) {
				$settings['presets'] = $this->get_presets();
			}
			if(in_array('shortcodes', $export)) {
				$settings['custom_shortcodes'] = wp_shortcode()->create_shortcode->get_custom_shortcode_details();
			}
			if(in_array('mapped_shortcodes', $export)) {
				$settings['mapped_shortcodes'] = $this->get_mapped_shortcodes();
			}
			if(!empty($settings)) {
				$encoded_options = wp_json_encode( $settings );
				header( 'Content-Description: File Transfer' );
				header( 'Content-type: application/txt' );
				header( 'Content-Disposition: attachment; filename="wps_settings_' . date( 'Y-m-d' ) . '.json"' );
				header( 'Content-Transfer-Encoding: binary' );
				header( 'Expires: 0' );
				header( 'Cache-Control: must-revalidate' );
				header( 'Pragma: public' );
				echo $encoded_options;
				exit;
			}
		}
	}

	function get_presets() {
		global $wpdb;
		$query = "SELECT option_name, option_value FROM `{$wpdb->prefix}options` WHERE `option_name` LIKE '%_presets_%'";
		$settings = $wpdb->get_results($query);
		return $settings;
	}

	function get_mapped_shortcodes() {
		return $mapped_shortcodes = get_option('wps_mapper');
	}
}

/**
 * Init the setting manager.
 */
wp_shortcode()->settings = new WP_Shortcode_Settings;