// DOM.event.move
//
// 2.0.0
//
// Stephen Band
//
// Triggers 'movestart', 'move' and 'moveend' events after
// mousemoves following a mousedown cross a distance threshold,
// similar to the native 'dragstart', 'drag' and 'dragend' events.
// Move events are throttled to animation frames. Move event objects
// have the properties:
//
// pageX:
// pageY:     Page coordinates of pointer.
// startX:
// startY:    Page coordinates of pointer at movestart.
// distX:
// distY:     Distance the pointer has moved since movestart.
// deltaX:
// deltaY:    Distance the finger has moved since last event.
// velocityX:
// velocityY: Average velocity over last few events.

!function(e){"function"==typeof define&&define.amd?define([],e):"undefined"!=typeof module&&null!==module&&module.exports?module.exports=e:e()}(function(){var e=Object.assign||window.jQuery&&jQuery.extend,t=8,n=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e,t){return window.setTimeout(function(){e()},25)};!function(){if("function"==typeof window.CustomEvent)return!1;function e(e,t){t=t||{bubbles:!1,cancelable:!1,detail:void 0};var n=document.createEvent("CustomEvent");return n.initCustomEvent(e,t.bubbles,t.cancelable,t.detail),n}e.prototype=window.Event.prototype,window.CustomEvent=e}();var i={textarea:!0,input:!0,select:!0,button:!0},o={move:"mousemove",cancel:"mouseup dragstart",end:"mouseup"},a={move:"touchmove",cancel:"touchend",end:"touchend"},c=/\s+/,r={bubbles:!0,cancelable:!0},u="function"==typeof Symbol?Symbol("events"):{};function d(e){return e[u]||(e[u]={})}function s(e,t,n,i,o){t=t.split(c);var a,r=d(e),u=t.length;function s(e){n(e,i)}for(;u--;)(r[a=t[u]]||(r[a]=[])).push([n,s]),e.addEventListener(a,s)}function v(e,t,n,i){t=t.split(c);var o,a,r,u=d(e),s=t.length;if(u)for(;s--;)if(a=u[o=t[s]])for(r=a.length;r--;)a[r][0]===n&&(e.removeEventListener(o,a[r][1]),a.splice(r,1))}function l(t,n,i){var o=new CustomEvent(n,r);i&&e(o,i),t.dispatchEvent(o)}function f(){}function m(e){e.preventDefault()}function p(e,t){var n,i;if(e.identifiedTouch)return e.identifiedTouch(t);for(n=-1,i=e.length;++n<i;)if(e[n].identifier===t)return e[n]}function h(e,t){var n=p(e.changedTouches,t.identifier);if(n&&(n.pageX!==t.pageX||n.pageY!==t.pageY))return n}function w(e,t){Y(e,t,e,y)}function g(e,t){y()}function y(){v(document,o.move,w),v(document,o.cancel,g)}function X(e){v(document,a.move,e.touchmove),v(document,a.cancel,e.touchend)}function Y(e,n,i,o){var a,c,r,u,d,s,v,m,p,h=i.pageX-n.pageX,w=i.pageY-n.pageY;h*h+w*w<t*t||(c=n,r=i,u=h,d=w,s=o,v=(a=e).targetTouches,m=a.timeStamp-c.timeStamp,p={altKey:a.altKey,ctrlKey:a.ctrlKey,shiftKey:a.shiftKey,startX:c.pageX,startY:c.pageY,distX:u,distY:d,deltaX:u,deltaY:d,pageX:r.pageX,pageY:r.pageY,velocityX:u/m,velocityY:d/m,identifier:c.identifier,targetTouches:v,finger:v?v.length:1,enableMove:function(){this.moveEnabled=!0,this.enableMove=f,a.preventDefault()}},l(c.target,"movestart",p),s(c))}function b(e,t){var n=t.timer;t.touch=e,t.timeStamp=e.timeStamp,n.kick()}function _(e,t){var n=t.target,i=t.event,a=t.timer;v(document,o.move,b),v(document,o.end,_),C(n,i,a,function(){setTimeout(function(){v(n,"click",m)},0)})}function T(e,t){var n,i=t.target,o=t.event,c=t.timer;p(e.changedTouches,o.identifier)&&(n=t,v(document,a.move,n.activeTouchmove),v(document,a.end,n.activeTouchend),C(i,o,c))}function C(e,t,n,i){n.end(function(){return l(e,"moveend",t),i&&i()})}if(s(document,"mousedown",function(e){var t;1!==(t=e).which||t.ctrlKey||t.altKey||i[e.target.tagName.toLowerCase()]||(s(document,o.move,w,e),s(document,o.cancel,g,e))}),s(document,"touchstart",function(e){if(!i[e.target.tagName.toLowerCase()]){var t=e.changedTouches[0],n={target:t.target,pageX:t.pageX,pageY:t.pageY,identifier:t.identifier,touchmove:function(e,t){var n,i,o;(o=h(n=e,i=t))&&Y(n,i,o,X)},touchend:function(e,t){var n;n=t,p(e.changedTouches,n.identifier)&&X(n)}};s(document,a.move,n.touchmove,n),s(document,a.cancel,n.touchend,n)}}),s(document,"movestart",function(e){if(!e.defaultPrevented&&e.moveEnabled){var t={startX:e.startX,startY:e.startY,pageX:e.pageX,pageY:e.pageY,distX:e.distX,distY:e.distY,deltaX:e.deltaX,deltaY:e.deltaY,velocityX:e.velocityX,velocityY:e.velocityY,identifier:e.identifier,targetTouches:e.targetTouches,finger:e.finger},i={target:e.target,event:t,timer:new function(e){var t=e,i=!1,o=!1;function a(e){i?(t(),n(a),o=!0,i=!1):o=!1}this.kick=function(e){i=!0,o||a()},this.end=function(e){var n=t;e&&(o?(t=i?function(){n(),e()}:e,i=!0):e())}}(function(e){var n,o,a,c;n=t,o=i.touch,a=i.timeStamp,c=a-n.timeStamp,n.distX=o.pageX-n.startX,n.distY=o.pageY-n.startY,n.deltaX=o.pageX-n.pageX,n.deltaY=o.pageY-n.pageY,n.velocityX=.3*n.velocityX+.7*n.deltaX/c,n.velocityY=.3*n.velocityY+.7*n.deltaY/c,n.pageX=o.pageX,n.pageY=o.pageY,l(i.target,"move",t)}),touch:void 0,timeStamp:e.timeStamp};void 0===e.identifier?(s(e.target,"click",m),s(document,o.move,b,i),s(document,o.end,_,i)):(i.activeTouchmove=function(e,t){var n,i,o,a,c;n=e,o=(i=t).event,a=i.timer,(c=h(n,o))&&(n.preventDefault(),o.targetTouches=n.targetTouches,i.touch=c,i.timeStamp=n.timeStamp,a.kick())},i.activeTouchend=function(e,t){T(e,t)},s(document,a.move,i.activeTouchmove,i),s(document,a.end,i.activeTouchend,i))}}),window.jQuery){var E="startX startY pageX pageY distX distY deltaX deltaY velocityX velocityY".split(" ");jQuery.event.special.movestart={setup:function(){return s(this,"movestart",k),!1},teardown:function(){return v(this,"movestart",k),!1},add:j},jQuery.event.special.move={setup:function(){return s(this,"movestart",S),!1},teardown:function(){return v(this,"movestart",S),!1},add:j},jQuery.event.special.moveend={setup:function(){return s(this,"movestart",x),!1},teardown:function(){return v(this,"movestart",x),!1},add:j}}function k(e){e.enableMove()}function S(e){e.enableMove()}function x(e){e.enableMove()}function j(e){var t=e.handler;e.handler=function(e){for(var n,i=E.length;i--;)e[n=E[i]]=e.originalEvent[n];t.apply(this,arguments)}}}),function(e){e.fn.twentytwenty=function(t){t=e.extend({default_offset_pct:.5,orientation:"horizontal",before_label:"Before",after_label:"After",no_overlay:!1,move_slider_on_hover:!1,move_with_handle_only:!0,click_to_move:!1},t);return this.each(function(){var n=t.default_offset_pct,i=e(this),o=t.orientation,a="vertical"===o?"down":"left",c="vertical"===o?"up":"right";i.wrap("<div class='twentytwenty-wrapper twentytwenty-"+o+"'></div>"),t.no_overlay||i.append("<div class='twentytwenty-overlay'></div>");var r=i.find("img:first"),u=i.find("img:last");i.append("<div class='twentytwenty-handle'></div>");var d=i.find(".twentytwenty-handle");d.append("<span class='twentytwenty-"+a+"-arrow'></span>"),d.append("<span class='twentytwenty-"+c+"-arrow'></span>"),i.addClass("twentytwenty-container"),r.addClass("twentytwenty-before"),u.addClass("twentytwenty-after");var s=i.find(".twentytwenty-overlay");s.append("<div class='twentytwenty-before-label' data-content='"+t.before_label+"'></div>"),s.append("<div class='twentytwenty-after-label' data-content='"+t.after_label+"'></div>");var v=function(e){var t,n,a,c,s=(t=e,n=r.width(),a=r.height(),{w:n+"px",h:a+"px",cw:t*n+"px",ch:t*a+"px"});d.css("vertical"===o?"top":"left","vertical"===o?s.ch:s.cw),c=s,"vertical"===o?(r.css("clip","rect(0,"+c.w+","+c.ch+",0)"),u.css("clip","rect("+c.ch+","+c.w+","+c.h+",0)")):(r.css("clip","rect(0,"+c.cw+","+c.h+",0)"),u.css("clip","rect(0,"+c.w+","+c.h+","+c.cw+")")),i.css("height",c.h)},l=function(e,t){var n,i,a;return n="vertical"===o?(t-m)/h:(e-f)/p,i=0,a=1,Math.max(i,Math.min(a,n))};e(window).on("resize.twentytwenty",function(e){v(n)});var f=0,m=0,p=0,h=0,w=function(e){(e.distX>e.distY&&e.distX<-e.distY||e.distX<e.distY&&e.distX>-e.distY)&&"vertical"!==o?e.preventDefault():(e.distX<e.distY&&e.distX<-e.distY||e.distX>e.distY&&e.distX>-e.distY)&&"vertical"===o&&e.preventDefault(),i.addClass("active"),f=i.offset().left,m=i.offset().top,p=r.width(),h=r.height()},g=function(e){i.hasClass("active")&&(n=l(e.pageX,e.pageY),v(n))},y=function(){i.removeClass("active")},X=t.move_with_handle_only?d:i;X.on("movestart",w),X.on("move",g),X.on("moveend",y),t.move_slider_on_hover&&(i.on("mouseenter",w),i.on("mousemove",g),i.on("mouseleave",y)),d.on("touchmove",function(e){e.preventDefault()}),i.find("img").on("mousedown",function(e){e.preventDefault()}),t.click_to_move&&i.on("click",function(e){f=i.offset().left,m=i.offset().top,p=r.width(),h=r.height(),n=l(e.pageX,e.pageY),v(n)}),e(window).trigger("resize.twentytwenty")})}}(jQuery);

jQuery(document).ready(function($){
	$(".wps-compare_image").each(function(){
		var data = $(this).data();
		$(this).twentytwenty({
			default_offset_pct: 0.5,
			no_overlay: false,
			before_label: data.before_label,
			after_label: data.after_label,
			orientation: data.orientation
		});
	});
});