var app = new Vue({
  el: '.wrapper',
  data: {
    start: false,
    done: false,
    word: [],
    timerWidth: 0,
    currentLetter: '',
    currentLetterIndex: 0,
    countWords: 0
  },
  created: function () {
    let self = this;
    window.addEventListener('keypress', function (e) {
      var key = e.which || e.keyCode;
      if (key === 13 && self.start === false) {
        self.startGame();
      }
      
      if(self.start == true && self.word.length != 0){
        self.checkKeyCode(key);
      }
      
    });
  },
  methods: {
    startGame: function() {      
      this.start = true;
      this.word = this.fetchWord().split('');
      this.startTimer();
    },
    resetGame: function() {
      this.start = false;
      this.done = false;
      this.word = [];
      this.timerWidth = 0;
      this.currentLetter = '';
      this.currentLetterIndex = 0;
      this.countWords = 0;
    },
    startTimer: function() {
      let count = 0;
      
      setInterval(()=>{
        if(this.done === false && this.start == true){
          count++;
          this.timerWidth = Math.ceil((count/60)*100);
          
          if(count == 60){
            this.done = true;
          }  
        }                
      },1000);
    },
    checkKeyCode: function(key) {
      console.log(key);
      switch(key){
        case 97:
          this.currentLetter = 'a';
          break;
        case 98:
          this.currentLetter = 'b';
          break;
        case 99:
          this.currentLetter = 'c';
          break;
        case 100:
          this.currentLetter = 'd';
          break;
        case 101:
          this.currentLetter = 'e';
          break;
        case 102:
          this.currentLetter = 'f';
          break;
        case 103:
          this.currentLetter = 'g';
          break;
        case 104:
          this.currentLetter = 'h';
          break;
        case 105:
          this.currentLetter = 'i';
          break;
        case 106:
          this.currentLetter = 'j';
          break;
        case 107:
          this.currentLetter = 'k';
          break;
        case 108:
          this.currentLetter = 'l';
          break;
        case 109:
          this.currentLetter = 'm';
          break;
        case 110:
          this.currentLetter = 'n';
          break;
        case 111:
          this.currentLetter = 'o';
          break;
        case 112:
          this.currentLetter = 'p';
          break;
        case 113:
          this.currentLetter = 'q';
          break;
        case 114:
          this.currentLetter = 'r';
          break;
        case 115:
          this.currentLetter = 's';
          break;
        case 116:
          this.currentLetter = 't';
          break;
        case 117:
          this.currentLetter = 'u';
          break;
        case 118:
          this.currentLetter = 'v';
          break;
        case 119:
          this.currentLetter = 'w';
          break;
        case 120:
          this.currentLetter = 'x';
          break;
        case 121:
          this.currentLetter = 'y';
          break;
        case 122:
          this.currentLetter = 'z';
          break;
        default:
          this.currentLetter = '';
          break;
      }
      this.checkLetterInWord();
    },
    checkLetterInWord: function() {
      if(this.word[this.currentLetterIndex] === this.currentLetter){
        this.currentLetterIndex++;
        
        if(this.currentLetterIndex === this.word.length){
          this.word = this.fetchWord().split('');
          this.countWords++;
          this.currentLetterIndex = 0;
          this.currentLetter = '';
        }
      }else{
        console.log("NO");
      }
    },
    fetchWord: function() {
      let randomIndex = Math.floor(Math.random() * words.data.length);
      return words.data[randomIndex].word.toLowerCase();
    }
  }
});

let words = {"data":[
{"word":"bakery"},
{"word":"bank"},
{"word":"beauty"},
{"word":"shop"},
{"word":"clothing"},
{"word":"store"},
{"word":"food"},
{"word":"court"},
{"word":"gift"},
{"word":"grocery"},
{"word":"library"},
{"word":"music"},
{"word":"pet"},
{"word":"restaurant"},
{"word":"sports"},
{"word":"across"},
{"word":"around"},
{"word":"corner"},
{"word":"between"},
{"word":"block"} ,
{"word":"buildings"},
{"word":"direction"},
{"word":"left"} ,
{"word":"next"},
{"word":"over"},
{"word":"there"},
{"word":"place"} ,
{"word":"right"},
{"word":"stop"},
{"word":"straight"} ,
{"word":"street"},
{"word":"town"},
{"word":"traffic"},
{"word":"light"} ,
{"word":"turn"},
{"word":"way"}
]};