/* ---------------
 xINIT STATE
--------------- */
const gameState = document.getElementById("game_state");

const gameContainer = document.getElementById("gs_container");

const gameBoard = document.querySelector(".gameboard");

const gamePlay = document.querySelector(".play-btn");

const newGameBtn = document.querySelector(".shuffle-btn");

//when play button is clicked
gamePlay.addEventListener("click", () => {
  //enter gamestate
  gameState.classList.toggle("active");
  //add gameboard tiles
  addTiles();
});

//When new game btn is clicked
newGameBtn.addEventListener("click", () => {
  gameContainer.classList.add("rotateScale");
  setTimeout(clearRotate, 200000);
  addTiles();
});


/* ---------------
    xGAME STATE
    --------------- */

//GAME LETTERS ARRAY
let letters = ["CAT", "CAT", "RAT", "RAT", "MAT", "MAT", "PAT", "PAT", "FAT", "FAT", "HAT", "HAT"];

let selectedTiles = [];
let selectedTileId = [];
let letter_id = 0;
let correct_tiles = 0;

//function to shuffle the letters array
Array.prototype.shuffle_board = function () {
  let input = this;

  for (let i = input.length - 1; i >= 0; i--) {
    let randomIndex = Math.floor(Math.random() * (i + 1));
    let letterAtIndex = input[randomIndex];

    input[randomIndex] = input[i];
    input[i] = letterAtIndex;
  }
  return input;
};

//PUTTING TILES IN PLAY
function addTiles() {

  //SET correct letters to 0, call shuffle on letters array
  correct_tiles = 0;

  letters.shuffle_board();

  //create a div for each sfuffled letter, increment each tile id and insert the letter
  let tiles = "";
  let i;
  for (i = 0; i <= letters.length - 1; i++) {
    tiles +=
    '<div class="tile" id="tile_' +
    i +
    '"><div class="tileContent front"></div><div class="tileContent back" data-letter = "' +
    letters[i] +
    '"></div></div>';
  }

  //clear selected letters and letter id arrays
  selectedTiles = [];
  selectedTileId = [];

  // if the tiles are being added back in after completing the game
  //remove the scale class

  gameContainer.classList.remove("scaleIt");

  //put divs in to game board
  gameBoard.innerHTML = tiles;

  setTimeout(scaleUp, 200);

  flipTiles();
}

//flipping the tile and revealing the letter when it's clciked
function flipTiles() {
  let gameTiles = document.querySelectorAll(".tile");

  //for each tile
  gameTiles.forEach(tile => {
    let tileBack = tile.querySelector(".back");

    //when a tile is clicked
    tile.addEventListener("click", () => {
      /* this prevents the rest of the function from running IF the clicked tile has already been matched with another one.
                                            if the clicked tile has a data-match attribute of yes, stop the rest of the function from running || 
                                              if the selectedTiles array has to values (two cards have been flipped) 
                                                - dont allow another click until a match or fail has been established */

      let dataMatch = tileBack.getAttribute("data-match");

      if (dataMatch == "yes" || selectedTiles.length === 2) {
        return false;
      } else {
        /* if the data-matach attribute is not found, continue with the rest of the function 
              || if a third click hasnt been made */

        //get data letter for clicked tile
        let showLetter = tileBack.getAttribute("data-letter");

        //get id value of clicked tile and put it into an array
        let getTileId = tile.getAttribute("id");

        //put data letter in to element html
        tileBack.innerHTML = showLetter;

        //flip tile
        tile.classList.toggle("flipped");

        //if selected letters array is empty
        if (selectedTiles.length === 0) {

          //put data letter and tile id into arrays
          selectedTiles.push(showLetter);
          selectedTileId.push(getTileId);

        } else if (selectedTiles.length === 1) {

          //put data letter and tile id into array
          selectedTiles.push(showLetter);
          selectedTileId.push(getTileId);

          //if the letters match
          if (selectedTiles[0] === selectedTiles[1]) {
            correct_tiles += 2;

            let m1 = document.querySelector("#" + selectedTileId[0] + " .back");
            let m2 = document.querySelector("#" + selectedTileId[1] + " .back");
            let m1_dm = m1.getAttribute("data-letter");
            let m2_dm = m2.getAttribute("data-letter");

            //add data match attribute to each tile
            if (
            m1_dm === selectedTiles[0] ||
            m1_dm === selectedTiles[1] ||
            m2_dm === selectedTiles[0] ||
            m2_dm === selectedTiles[1])
            {
              m1.setAttribute("data-match", "yes");
              m2.setAttribute("data-match", "yes");
            }
            //empty data letter and tile id arrays
            selectedTiles = [];
            selectedTileId = [];

            if (correct_tiles === letters.length) {
              alert('Well done! Play Again! ');
              gameContainer.classList.add("scaleIt");

              //setTimeout(removeBoard, 2000);
              selectedTiles = [];
              selectedTileId = [];
              correct_tiles = 0;
              setTimeout(addTiles, 1500);
            }
          } else {
            //run remove toggle after 1s
            setTimeout(removeToggle, 900);
          }
        }
      }
    }); //end when tile is clicked
  }); //end for each tile
} //end fliptiles

//scale up gamecontainer and tiles
function scaleUp() {
  gameContainer.classList.add("scaleUp");
  let xx = document.querySelectorAll(".tile");
  xx.forEach(x => {
    x.classList.add("active");
  });
}

//clear scale rotation
function clearRotate() {
  gameContainer.classList.remove("rotateScale");
}

//remove flipped class
function removeToggle() {
  //get selected tiles by tile id
  let l1 = document.getElementById(selectedTileId[0]);
  let l2 = document.getElementById(selectedTileId[1]);

  //remove flipped class from both tiled
  l1.classList.remove("flipped");
  l2.classList.remove("flipped");

  //empty data letter and tile id arrays
  selectedTiles = [];
  selectedTileId = [];
}