/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;

public final class WordMagnets2ech
extends Applet {
    AppletUtil3 aut;
    Color bg;
    Color fg;
    Color mcolor;
    FontMetrics fm;
    Graphics wordG;
    Graphics bufferG;
    Image wordI;
    Image bufferI;
    int width;
    int height;
    int cx;
    int cy;
    int dx;
    int dy;
    int picked_rect = -1;
    int edit_rect = -1;
    Vector rects = new Vector(23);
    Vector words = new Vector(23);

    public void init() {
        this.aut = new AppletUtil3(this);
        this.width = this.size().width;
        this.height = this.size().height;
        this.wordI = this.createImage(this.width, this.height);
        this.wordG = this.wordI.getGraphics();
        this.wordG.setFont(this.aut.getFont());
        this.bufferI = this.createImage(this.width, this.height);
        this.bufferG = this.bufferI.getGraphics();
        this.bufferG.setFont(this.aut.getFont());
        this.fm = this.bufferG.getFontMetrics();
        this.bg = this.aut.makeColor(this.getParameter("BGCOLOR"), Color.black);
        this.fg = this.aut.makeColor(this.getParameter("FGCOLOR"), Color.black);
        this.mcolor = this.aut.makeColor(this.getParameter("MAGNET.COLOR"), Color.lightGray);
        String string = this.getParameter("WORDFILE");
        if (string != null) {
            try {
                String string2;
                URL uRL = new URL(this.getDocumentBase(), string);
                URLConnection uRLConnection = uRL.openConnection();
                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                while ((string2 = dataInputStream.readLine()) != null && !string2.trim().equals("")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    String string3 = stringTokenizer.nextToken();
                    this.words.addElement(string3);
                    int n = this.fm.getMaxDescent() + this.fm.stringWidth(string3);
                    int n2 = this.fm.getHeight();
                    int n3 = (int)(Math.random() * (double)(this.width - n));
                    int n4 = (int)(Math.random() * (double)(this.height - n2));
                    if (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        n3 = this.aut.getRandom(this.aut.pre(string4, ","));
                        n4 = this.aut.getRandom(this.aut.post(string4, ","));
                    }
                    this.rects.addElement(new Rectangle(n3, n4, n, n2));
                }
                dataInputStream.close();
            }
            catch (Exception exception) {}
        }
        this.createWordField();
        this.repaint();
    }

    public void createWordField() {
        this.wordG.setColor(this.bg);
        this.wordG.fillRect(0, 0, this.width, this.height);
        int n = 0;
        while (n < this.words.size()) {
            if (n != this.picked_rect && n != this.edit_rect) {
                Rectangle rectangle = (Rectangle)this.rects.elementAt(n);
                this.wordG.setColor(this.mcolor);
                this.wordG.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                this.wordG.setColor(this.fg);
                this.wordG.drawString((String)this.words.elementAt(n), rectangle.x + this.fm.getMaxDescent() / 2, rectangle.y + rectangle.height - this.fm.getMaxDescent());
            }
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        this.bufferG.drawImage(this.wordI, 0, 0, this);
        if (this.picked_rect != -1) {
            Rectangle rectangle = (Rectangle)this.rects.elementAt(this.picked_rect);
            this.bufferG.setColor(this.mcolor);
            this.bufferG.fill3DRect(this.cx - this.dx, this.cy - this.dy, rectangle.width, rectangle.height, true);
            this.bufferG.setColor(this.fg);
            this.bufferG.drawString((String)this.words.elementAt(this.picked_rect), this.cx - this.dx + this.fm.getMaxDescent() / 2, this.cy - this.dy + rectangle.height - this.fm.getMaxDescent());
        } else if (this.edit_rect != -1) {
            Rectangle rectangle = (Rectangle)this.rects.elementAt(this.edit_rect);
            this.bufferG.setColor(this.mcolor);
            this.bufferG.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            this.bufferG.setColor(this.fg);
            this.bufferG.drawString((String)this.words.elementAt(this.edit_rect), rectangle.x + this.fm.getMaxDescent() / 2, rectangle.y + rectangle.height - this.fm.getMaxDescent());
        }
        if (this.getParameter("AUTHOR").equals("Eric Harshbarger, http://www.ericharshbarger.org") && this.getParameter("COPYRIGHT").equals("WordMagnets applet, Copyright 1998, Eric Harshbarger")) {
            graphics.drawImage(this.bufferI, 0, 0, this);
            return;
        }
        System.out.println("AUTHOR & COPYRIGHT parameters are incorrect.");
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void destroy() {
        if (this.bufferG != null) {
            this.bufferG.dispose();
        }
    }

    public int pickRectangle(int n, int n2) {
        int n3 = this.words.size() - 1;
        while (n3 > -1) {
            if (((Rectangle)this.rects.elementAt(n3)).inside(n, n2)) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.modifiers == 1) {
            this.edit_rect = this.pickRectangle(n, n2);
            if (this.edit_rect == -1) {
                this.words.addElement("");
                this.rects.addElement(new Rectangle(n, n2, this.fm.getMaxDescent() + this.fm.stringWidth(""), this.fm.getHeight()));
                this.edit_rect = this.words.size() - 1;
            }
            this.picked_rect = -1;
            this.dx = 0;
            this.dy = 0;
        } else {
            this.edit_rect = -1;
            this.picked_rect = this.pickRectangle(n, n2);
            if (this.picked_rect != -1) {
                Rectangle rectangle = (Rectangle)this.rects.elementAt(this.picked_rect);
                this.cx = n;
                this.cy = n2;
                this.dx = n - rectangle.x;
                this.dy = n2 - rectangle.y;
            }
        }
        this.createWordField();
        this.repaint();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.cx = n;
        this.cy = n2;
        this.repaint();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.picked_rect != -1) {
            Rectangle rectangle = (Rectangle)this.rects.elementAt(this.picked_rect);
            this.rects.setElementAt(new Rectangle(this.cx - this.dx, this.cy - this.dy, rectangle.width, rectangle.height), this.picked_rect);
            this.picked_rect = -1;
            this.dx = 0;
            this.dy = 0;
            this.createWordField();
            this.repaint();
        }
        return true;
    }

    public boolean keyUp(Event event, int n) {
        if (this.edit_rect != -1) {
            if (n == 8 || n > 32 && n < 127) {
                String string = (String)this.words.elementAt(this.edit_rect);
                if (n == 8 && string.equals("")) {
                    this.words.removeElementAt(this.edit_rect);
                    this.rects.removeElementAt(this.edit_rect);
                    this.edit_rect = -1;
                } else {
                    Rectangle rectangle = (Rectangle)this.rects.elementAt(this.edit_rect);
                    String string2 = n == 8 ? string.substring(0, string.length() - 1) : string + (char)n;
                    Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, this.fm.getMaxDescent() + this.fm.stringWidth(string2), rectangle.height);
                    this.words.setElementAt(string2, this.edit_rect);
                    this.rects.setElementAt(rectangle2, this.edit_rect);
                }
            }
            this.repaint();
        }
        return true;
    }
}

